document.addEventListener("DOMContentLoaded", () => {
    // Function to find and update the CSS path for presets
    function updatePresetCss(currentPreset) {
        const links = document.querySelectorAll('link[rel="stylesheet"]');
        const presetPattern = /css\/presets\/preset\d+\.css/;

        links.forEach((link) => {
            if (presetPattern.test(link.href)) {
                // Update href with the new preset
                link.href = `${helixultimate_template_uri}/css/presets/preset${currentPreset}.css`;
            }
        });
    }

    // Function to manage cookies (set and get)
    function manageCookie(name, value, days) {
        if (value !== undefined) {
            // Set a new cookie
            const expirationTime = new Date(
                Date.now() + days * 86400000
            ).toUTCString();
            document.cookie = `${name}=${value}; expires=${expirationTime}; path=/;`;
        } else {
            // Get the current cookie value
            const cookies = document.cookie.split(";");
            for (let i = 0; i < cookies.length; i++) {
                const cookie = cookies[i].trim();
                if (cookie.startsWith(name + "=")) {
                    return cookie.substring(name.length + 1);
                }
            }
            return null;
        }
    }

    // Function to remove a cookie
    function removeCookie(name) {
        document.cookie = `${name}=; expires=Thu, 01 Jan 1970 00:00:00 UTC; path=/;`;
    }

    // Preset selection
    const presets = document.querySelectorAll(".helixultimate-presets li");
    presets.forEach((preset) => {
        preset.querySelector("a").addEventListener("click", (e) => {
            e.preventDefault();

            const currentPreset = preset.dataset.preset;

            // Update active class
            presets.forEach((p) => p.classList.remove("active"));
            preset.classList.add("active");

            // Update logos
            const defaultLogo = document.querySelector(
                "body:not(.no-presets-logo) .logo-image"
            );
            if (defaultLogo) {
                defaultLogo.src = `${helixultimate_template_uri}/images/presets/preset${currentPreset}/logo.svg`;
            }

            // Update the CSS path for the current preset
            updatePresetCss(currentPreset);

            // Set cookie for the selected preset
            manageCookie(
                `${helixultimate_template}_preset`,
                `preset${currentPreset}`,
                1
            ); // 1-day expiration
        });
    });

    // On page load, get the saved preset from the cookie and apply it
    const savedPreset = manageCookie(`${helixultimate_template}_preset`);
    if (savedPreset) {
        // Find the matching preset based on the cookie value
        const matchingPreset = Array.from(presets).find(
            (preset) => `preset${preset.dataset.preset}` === savedPreset
        );
        if (matchingPreset) {
            matchingPreset.querySelector("a").click(); // Trigger the preset click to apply it
        }
    }
});
