<?php

/**
 * @package     Joomla.Site
 * @subpackage  mod_helixultimate_options
 *
 * @copyright   (C) 2024 JoomShaper. <https://www.joomshaper.com>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;

\defined('_JEXEC') or die;

$app            = Factory::getApplication();
$doc            = Factory::getDocument();
$tplParams         = $app->getTemplate(true)->params;
$templateName     = $app->getTemplate();
$templateUrl      = Uri::base(true) . '/templates/' . $templateName;
$moduleUrl      = Uri::base(true) . '/modules/mod_helixultimate_options';
$presets = $tplParams->get('presets-data');
$all = json_decode($presets);
$current_preset = 'default';
if (isset($_COOKIE[$templateName . '_preset'])) {
    $current_preset = $_COOKIE[$templateName . '_preset'];
}

//Add scripts and styles
$doc->addStylesheet($moduleUrl . '/assets/css/helixultimate-options.css');
$doc->addScript($moduleUrl . '/assets/js/helixultimate-options.js');
$doc->addScriptdeclaration('var helixultimate_template = "' . $templateName . '";');
$doc->addScriptdeclaration('var helixultimate_template_uri = "' . $templateUrl . '";');

?>

<div class="template-options">
    <div class="options-inner">
        <div class="preset-icon" data-bs-toggle="collapse" href="#collapseExample">
            <svg width="16" height="17" viewBox="0 0 16 17" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path fill-rule="evenodd" clip-rule="evenodd"
                    d="M0.25 0.75H7.25V12.75C7.25 14.683 5.683 16.25 3.75 16.25C1.817 16.25 0.25 14.683 0.25 12.75V0.75ZM1.75 2.25V12.75C1.75 13.8546 2.64543 14.75 3.75 14.75C4.85457 14.75 5.75 13.8546 5.75 12.75V2.25H1.75Z"
                    fill="#415162" />
                <path
                    d="M4.25 12.716C4.25 12.9921 4.02614 13.216 3.75 13.216C3.47386 13.216 3.25 12.9921 3.25 12.716C3.25 12.4398 3.47386 12.216 3.75 12.216C4.02614 12.216 4.25 12.4398 4.25 12.716Z"
                    fill="#415162" />
                <path fill-rule="evenodd" clip-rule="evenodd"
                    d="M9.89941 0.9375L14.8492 5.88725L8 13L7.96967 10.6454L12.7278 5.88725L9.89941 3.05882L8 5L7.96967 2.86724L9.89941 0.9375Z"
                    fill="#415162" />
                <path fill-rule="evenodd" clip-rule="evenodd"
                    d="M15.75 9.25V16.25H6L7.5 14.75H14.25V10.75H11L12.5 9.25H15.75Z" fill="#415162" />
            </svg>
            <span>
                <i class="fas fa-chevron-up"></i>
                <i class="fas fa-chevron-down"></i>
            </span>

        </div>
        <div class="option-section collapse show" id="collapseExample">
            <ul class="helixultimate-presets clearfix">
                <?php for ($i = 1; $i < $params->get('presets') + 1; $i++) {
                    $preset_color = $all->{'preset' . $i}->default;
                    $active = ($current_preset == 'preset' . $i) ? ' active' : '';
                ?>
                <li class="helixultimate-preset<?php echo $i . $active; ?>" data-preset="<?php echo $i; ?>">
                    <a style="background-color: <?php echo $preset_color; ?>" href="#"></a>
                </li>
                <?php } ?>
            </ul>
        </div>
    </div>
</div>